package cn.boboweike.carrot.tasks.details;

import cn.boboweike.carrot.tasks.TaskDetails;
import cn.boboweike.carrot.tasks.lambdas.*;

import java.lang.annotation.Annotation;

import static cn.boboweike.carrot.tasks.details.SerializedLambdaConverter.toSerializedLambda;
import static java.util.Arrays.stream;

public class TaskDetailsAsmGenerator implements TaskDetailsGenerator {

    @Override
    public TaskDetails toTaskDetails(TaskLambda lambda) {
        if (isKotlinLambda(lambda)) {
            return new KotlinTaskDetailsFinder(lambda).getTaskDetails();
        } else {
            return new JavaTaskDetailsFinder(lambda, toSerializedLambda(lambda)).getTaskDetails();
        }
    }

    @Override
    public TaskDetails toTaskDetails(IocTaskLambda lambda) {
        if (isKotlinLambda(lambda)) {
            return new KotlinTaskDetailsFinder(lambda, new Object()).getTaskDetails();
        } else {
            return new JavaTaskDetailsFinder(lambda, toSerializedLambda(lambda)).getTaskDetails();
        }
    }

    @Override
    public <T> TaskDetails toTaskDetails(T itemFromStream, TaskLambdaFromStream<T> lambda) {
        if (isKotlinLambda(lambda)) {
            return new KotlinTaskDetailsFinder(lambda, itemFromStream).getTaskDetails();
        } else {
            return new JavaTaskDetailsFinder(lambda, toSerializedLambda(lambda), itemFromStream).getTaskDetails();
        }
    }

    @Override
    public <S, T> TaskDetails toTaskDetails(T itemFromStream, IocTaskLambdaFromStream<S, T> lambda) {
        if (isKotlinLambda(lambda)) {
            // why new Object(): it represents the item injected when we run the IocTaskLambdaFromStream function
            return new KotlinTaskDetailsFinder(lambda, new Object(), itemFromStream).getTaskDetails();
        } else {
            // why null: it represents the item injected when we run the IocTaskLambdaFromStream function
            return new JavaTaskDetailsFinder(lambda, toSerializedLambda(lambda), null, itemFromStream).getTaskDetails();
        }
    }

    private <T extends CarrotTask> boolean isKotlinLambda(T lambda) {
        //return true;
        return stream(lambda.getClass().getAnnotations()).map(Annotation::annotationType).anyMatch(annotationType -> annotationType.getName().equals("kotlin.Metadata"));
    }
}
