package cn.boboweike.carrot.tasks.details.instructions;

import cn.boboweike.carrot.tasks.details.TaskDetailsBuilder;

import java.lang.reflect.Array;

import static cn.boboweike.carrot.tasks.details.TaskDetailsGeneratorUtils.toFQClassName;
import static cn.boboweike.carrot.utils.reflection.ReflectionUtils.toClass;

public class ANewArrayOperandInstruction extends VisitTypeInstruction {

    public ANewArrayOperandInstruction(TaskDetailsBuilder taskDetailsBuilder) {
        super(taskDetailsBuilder);
    }

    @Override
    public Object invokeInstruction() {
        Integer arraySize = (Integer) taskDetailsBuilder.getStack().pollLast();
        return Array.newInstance(toClass(toFQClassName(type)), arraySize);
    }
}
