package cn.boboweike.carrot.tasks.details.instructions;

import cn.boboweike.carrot.tasks.details.TaskDetailsBuilder;

public abstract class AbstractJVMInstruction {

    public static final Object DO_NOT_PUT_ON_STACK = new Object();

    protected final TaskDetailsBuilder taskDetailsBuilder;

    protected AbstractJVMInstruction(TaskDetailsBuilder taskDetailsBuilder) {
        this.taskDetailsBuilder = taskDetailsBuilder;
    }

    public abstract Object invokeInstruction();

    public void invokeInstructionAndPushOnStack() {
        Object result = invokeInstruction();
        if (result != DO_NOT_PUT_ON_STACK) {
            taskDetailsBuilder.getStack().add(result);
        }
    }
}
