package cn.boboweike.carrot.tasks.details.instructions;

import cn.boboweike.carrot.tasks.details.TaskDetailsBuilder;

import static cn.boboweike.carrot.tasks.details.TaskDetailsGeneratorUtils.getObjectViaStaticField;
import static cn.boboweike.carrot.tasks.details.TaskDetailsGeneratorUtils.toFQClassName;

public class GetStaticInstruction extends VisitFieldInstruction {

    public GetStaticInstruction(TaskDetailsBuilder taskDetailsBuilder) {
        super(taskDetailsBuilder);
    }

    @Override
    public Object invokeInstruction() {
        // TODO: how to know if we should invoke it or create TaskDetails with static field?
        String className = toFQClassName(owner);
        String methodName = name;

        if (className.equals(System.class.getName())) {
            taskDetailsBuilder.setClassName(className);
            taskDetailsBuilder.setStaticFieldName(name);
        }
        return getObjectViaStaticField(className, methodName);
    }
}
