package cn.boboweike.carrot.tasks.details.instructions;

import cn.boboweike.carrot.CarrotException;
import cn.boboweike.carrot.tasks.details.TaskDetailsBuilder;
import cn.boboweike.carrot.utils.reflection.ReflectionUtils;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;

import static cn.boboweike.carrot.tasks.details.TaskDetailsGeneratorUtils.*;
import static cn.boboweike.carrot.utils.reflection.ReflectionUtils.getValueFromFieldOrProperty;
import static cn.boboweike.carrot.utils.reflection.ReflectionUtils.toClass;
import static java.util.Arrays.stream;

public class InvokeSpecialInstruction extends VisitMethodInstruction {

    public InvokeSpecialInstruction(TaskDetailsBuilder taskDetailsBuilder) {
        super(taskDetailsBuilder);
    }

    @Override
    public Object invokeInstruction() {
        if ("<init>".equals(name)) {
            String className = toFQClassName(owner);
            Class<?>[] paramTypes = findParamTypesFromDescriptorAsArray(descriptor);
            List<Object> parameters = getParametersUsingParamTypes(paramTypes);

            Object objectViaConstructor = createObjectViaConstructor(className, paramTypes, parameters.toArray());
            if(isKotlinMethodReference(objectViaConstructor)) {
                taskDetailsBuilder.setClassName(((Class)getValueFromFieldOrProperty(objectViaConstructor, "owner")).getName());
                taskDetailsBuilder.setMethodName((String) getValueFromFieldOrProperty(objectViaConstructor, "name"));
            }
            return objectViaConstructor;
        }

        String className = toFQClassName(owner);
        Class<?> objectClass = toClass(className);
        Method method = ReflectionUtils.getMethod(objectClass, name, findParamTypesFromDescriptorAsArray(descriptor));
        if (Modifier.isPrivate(method.getModifiers())) {
            throw CarrotException.invalidLambdaException(new IllegalAccessException(String.format("Carrot cannot access member \"%s\" of class %s with modifiers \"private\". Please make the method \"public\".", name, className)));
        }

        throw CarrotException.shouldNotHappenException("Unknown INVOKESPECIAL instruction: " + className + "." + name);
    }

    private boolean isKotlinMethodReference(Object objectViaConstructor) {
        return stream(objectViaConstructor.getClass().getInterfaces())
                .map(Class::getName)
                .anyMatch(name -> name.startsWith("kotlin.jvm.functions.Function"));
    }

}
