package cn.boboweike.carrot.tasks.details.instructions;

import cn.boboweike.carrot.tasks.details.TaskDetailsBuilder;

public class SingleIntOperandInstruction extends AbstractJVMInstruction {

    private int intValue;

    public SingleIntOperandInstruction(TaskDetailsBuilder taskDetailsBuilder) {
        super(taskDetailsBuilder);
    }

    public void load(int intValue) {
        this.intValue = intValue;
        taskDetailsBuilder.pushInstructionOnStack(this);
    }

    @Override
    public Object invokeInstruction() {
        return intValue;
    }
}
