package cn.boboweike.carrot.tasks.details.instructions;

import cn.boboweike.carrot.tasks.details.TaskDetailsBuilder;

import java.util.LinkedList;

public class SwapOperandInstruction extends ZeroOperandInstruction {

    public SwapOperandInstruction(TaskDetailsBuilder taskDetailsBuilder) {
        super(taskDetailsBuilder);
    }

    @Override
    public void load() {
        taskDetailsBuilder.pushInstructionOnStack(this);
    }

    @Override
    public Object invokeInstruction() {
        LinkedList<Object> stack = taskDetailsBuilder.getStack();
        Object el1 = stack.get(0);
        Object el2 = stack.get(1);
        stack.set(0, el2);
        stack.set(1, el1);
        return DO_NOT_PUT_ON_STACK;
    }

}
