package cn.boboweike.carrot.tasks.details.instructions;

import cn.boboweike.carrot.tasks.details.TaskDetailsBuilder;

public abstract class VisitLocalVariableInstruction extends AbstractJVMInstruction {

    protected int variable;

    protected VisitLocalVariableInstruction(TaskDetailsBuilder taskDetailsBuilder) {
        super(taskDetailsBuilder);
    }

    public void load(int variable) {
        this.variable = variable;
        taskDetailsBuilder.pushInstructionOnStack(this);
    }

    @Override
    public Object invokeInstruction() {
        return taskDetailsBuilder.getLocalVariable(variable);
    }

}
