package cn.boboweike.carrot.tasks.details.instructions;

import cn.boboweike.carrot.tasks.details.TaskDetailsBuilder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

import static cn.boboweike.carrot.utils.reflection.ReflectionUtils.autobox;

public abstract class VisitMethodInstruction extends AbstractJVMInstruction {

    protected String owner;
    protected String name;
    protected String descriptor;
    protected boolean isInterface;

    protected VisitMethodInstruction(TaskDetailsBuilder taskDetailsBuilder) {
        super(taskDetailsBuilder);
    }

    public void load(String owner, String name, String descriptor, boolean isInterface) {
        this.owner = owner;
        this.name = name;
        this.descriptor = descriptor;
        this.isInterface = isInterface;
        taskDetailsBuilder.pushInstructionOnStack(this);
    }

    protected boolean isVoidInstruction() {
        return descriptor.endsWith(")V");
    }

    protected boolean isLastInstruction() {
        return taskDetailsBuilder.getInstructions().isEmpty();
    }

    protected List<Object> getParametersUsingParamTypes(Class<?>[] paramTypesAsArray) {
        LinkedList<Class<?>> paramTypes = new LinkedList<>(Arrays.asList(paramTypesAsArray));
        List<Object> result = new ArrayList<>();
        while (!paramTypes.isEmpty()) {
            Class<?> paramType = paramTypes.pollLast();
            result.add(0, autobox(taskDetailsBuilder.getStack().pollLast(), paramType));
        }
        return result;
    }

}
