package cn.boboweike.carrot.tasks.details.postprocess;

import cn.boboweike.carrot.tasks.TaskDetails;

import static cn.boboweike.carrot.utils.StringUtils.substringBefore;

public class CGLibPostProcessor implements TaskDetailsPostProcessor {
    @Override
    public TaskDetails postProcess(TaskDetails taskDetails) {
        if (taskDetails.getClassName().matches("(.*)\\$\\$EnhancerBy(.*)CGLIB(.*)")) {
            return new TaskDetails(
                    substringBefore(taskDetails.getClassName(), "$$EnhancerBy"),
                    taskDetails.getStaticFieldName(),
                    taskDetails.getMethodName(),
                    taskDetails.getTaskParameters()
            );
        }
        return taskDetails;
    }
}
