package cn.boboweike.carrot.tasks.filters;

import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.states.TaskState;

/**
 * A filter that is triggered each time that the state of a task has changed (except when the Task is deleted via the Dashboard).
 * Can be useful for adding extra logging, ... .
 * This filter will be called after that the task has been saved to a {@link cn.boboweike.carrot.storage.PartitionedStorageProvider}.
 * Altering the task will not have any influence as it is not saved.
 */
public interface ApplyStateFilter extends TaskFilter {

    /**
     * @param task      the task in which to apply the filter
     * @param oldState the previous state - can be null
     * @param newState the new state
     */
    void onStateApplied(Task task, TaskState oldState, TaskState newState);
}
