package cn.boboweike.carrot.tasks.filters;

import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.states.AllowedTaskStateStateChanges;
import cn.boboweike.carrot.tasks.states.TaskState;

/**
 * A filter that is triggered each time that the state of a Task is changed (except when the Task is deleted via the Dashboard).
 * This filter will be called before that the task has been saved to a {@link cn.boboweike.carrot.storage.PartitionedStorageProvider}.
 * Altering the task will change the lifecycle of the task - an example of this is the {@link RetryFilter} which updates tasks that are failed to scheduled again.
 * Every {@code ElectStateFilter} must also respect the allowed state changes. See {@link AllowedTaskStateStateChanges} for more info.
 */
public interface ElectStateFilter extends TaskFilter {

    void onStateElection(Task task, TaskState newState);

}
