package cn.boboweike.carrot.tasks.filters;

import cn.boboweike.carrot.tasks.AbstractTask;

/**
 * A filter that is triggered each time that a Task
 * <ul>
 *     <li>is about to be created (before it is saved to the {@link cn.boboweike.carrot.storage.PartitionedStorageProvider})</li>
 *     <li>has been created (after is has been saved in the {@link cn.boboweike.carrot.storage.PartitionedStorageProvider}</li>
 * </ul>
 */
public interface TaskClientFilter extends TaskFilter {

    default void onCreating(AbstractTask task) {}

    default void onCreated(AbstractTask task) {}

}