package cn.boboweike.carrot.tasks.filters;

import cn.boboweike.carrot.tasks.AbstractTask;
import cn.boboweike.carrot.utils.streams.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.stream.Stream;

public class TaskCreationFilters extends AbstractTaskFilters {

    private static final Logger LOGGER = LoggerFactory.getLogger(TaskCreationFilters.class);

    public TaskCreationFilters(AbstractTask task, TaskDefaultFilters taskDefaultFilters) {
        super(task, taskDefaultFilters);
    }

    public void runOnCreatingFilter() {
        taskClientFilters().forEach(catchThrowable(taskClientFilter -> taskClientFilter.onCreating(task)));
    }

    public void runOnCreatedFilter() {
        taskClientFilters().forEach(catchThrowable(taskClientFilter -> taskClientFilter.onCreated(task)));
    }

    private Stream<TaskClientFilter> taskClientFilters() {
        return StreamUtils.ofType(taskFilters, TaskClientFilter.class);
    }

    @Override
    Logger getLogger() {
        return LOGGER;
    }
}

