package cn.boboweike.carrot.tasks.filters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import static cn.boboweike.carrot.utils.CollectionUtils.isNullOrEmpty;

public class TaskDefaultFilters {

    private final List<TaskFilter> filters;

    public TaskDefaultFilters(TaskFilter... filters) {
        this(Arrays.asList(filters));
    }

    public TaskDefaultFilters(List<TaskFilter> filters) {
        this.filters = getAllTaskFilters(filters);
    }

    public void addAll(List<? extends TaskFilter> filters) {
        if (isNullOrEmpty(filters)) return;
        this.filters.addAll(filters);
    }

    List<TaskFilter> getFilters() {
        return filters;
    }

    private ArrayList<TaskFilter> getAllTaskFilters(List<TaskFilter> taskFilters) {
        final ArrayList<TaskFilter> result = new ArrayList<>(Arrays.asList(new DisplayNameFilter(), new RetryFilter()));
        result.addAll(taskFilters);
        return result;
    }
}
