package cn.boboweike.carrot.tasks.filters;

import cn.boboweike.carrot.tasks.AbstractTask;
import cn.boboweike.carrot.tasks.Task;

import java.util.List;

public class TaskFilterUtils {

    private TaskDefaultFilters taskDefaultFilters;

    public TaskFilterUtils(TaskDefaultFilters taskDefaultFilters) {
        this.taskDefaultFilters = taskDefaultFilters;
    }

    public void runOnCreatingFilter(AbstractTask task) {
        new TaskCreationFilters(task, taskDefaultFilters).runOnCreatingFilter();
    }

    public void runOnCreatedFilter(AbstractTask task) {
        new TaskCreationFilters(task, taskDefaultFilters).runOnCreatedFilter();
    }

    public void runOnCreatingFilter(List<Task> tasks) {
        tasks.forEach(this::runOnCreatingFilter);
    }

    public void runOnCreatedFilter(List<Task> tasks) {
        tasks.forEach(this::runOnCreatedFilter);
    }

    public void runOnStateElectionFilter(Task task) {
        new TaskPerformingFilters(task, taskDefaultFilters).runOnStateElectionFilter();
    }

    public void runOnStateAppliedFilters(Task task) {
        new TaskPerformingFilters(task, taskDefaultFilters).runOnStateAppliedFilters();
    }

    public void runOnStateElectionFilter(List<Task> tasks) {
        tasks.forEach(this::runOnStateElectionFilter);
    }

    public void runOnStateAppliedFilters(List<Task> tasks) {
        tasks.forEach(this::runOnStateAppliedFilters);
    }
}

