package cn.boboweike.carrot.tasks.filters;

import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.utils.streams.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.stream.Stream;

public class TaskPerformingFilters extends AbstractTaskFilters {

    private static final Logger LOGGER = LoggerFactory.getLogger(TaskPerformingFilters.class);

    private Task task;

    public TaskPerformingFilters(Task task, TaskDefaultFilters taskFilters) {
        super(task, taskFilters);
        this.task = task;
    }

    public void runOnStateElectionFilter() {
        electStateFilters().forEach(catchThrowable(electStateFilter -> electStateFilter.onStateElection(task, task.getTaskState())));
    }

    public void runOnStateAppliedFilters() {
        applyStateFilters().forEach(catchThrowable(applyStateFilter -> applyStateFilter.onStateApplied(task, task.getTaskState(-2), task.getTaskState(-1))));
    }

    public void runOnTaskProcessingFilters() {
        taskServerFilters().forEach(catchThrowable(taskServerFilter -> taskServerFilter.onProcessing(task)));
    }

    public void runOnTaskProcessedFilters() {
        taskServerFilters().forEach(catchThrowable(taskServerFilter -> taskServerFilter.onProcessed(task)));
    }

    private Stream<ElectStateFilter> electStateFilters() {
        return electStateFilters(taskFilters);
    }

    private Stream<ApplyStateFilter> applyStateFilters() {
        return applyStateFilters(taskFilters);
    }

    private Stream<TaskServerFilter> taskServerFilters() {
        return taskServerFilters(taskFilters);
    }

    private static Stream<ElectStateFilter> electStateFilters(List<TaskFilter> taskFilters) {
        return StreamUtils.ofType(taskFilters, ElectStateFilter.class);
    }

    private static Stream<ApplyStateFilter> applyStateFilters(List<TaskFilter> taskFilters) {
        return StreamUtils.ofType(taskFilters, ApplyStateFilter.class);
    }

    private static Stream<TaskServerFilter> taskServerFilters(List<TaskFilter> taskFilters) {
        return StreamUtils.ofType(taskFilters, TaskServerFilter.class);
    }

    @Override
    Logger getLogger() {
        return LOGGER;
    }
}
