package cn.boboweike.carrot.tasks.lambdas;

/**
 * This is a functional interface which represents a lambda that will be parsed by Carrot.
 * You <strong>may not create an actual instance of this class</strong>, instead you use it as follows:
 *
 * <pre>{@code
 *     BackgroundTask.<SomeService>enqueue(x -> x.doWork("some argument"))
 * }</pre>
 * <p>
 * or
 * <pre>{@code
 *     taskScheduler.<SomeService>enqueue(x -> x.doWork("some argument"))
 * }</pre>
 * <p>
 * This functional interface allows you to enqueue background tasks without having an actual instance available of your service.
 * While processing, Carrot will lookup the actual service in the IoC container or create a new instance using the default constructor.
 *
 * @param <S> Your service on which you want to call a background task method.
 */

@FunctionalInterface
public interface IocTaskLambda<S> extends CarrotTask {

    void accept(S service) throws Exception;
}
