package cn.boboweike.carrot.tasks.lambdas;

/**
 * This is a functional interface which allows you to schedule tasks based on a Stream and a lambda that will be parsed by Carrot.
 * You <strong>may not create an actual instance of this class</strong>, instead you use it as follows:
 *
 * <pre>{@code
 *     Stream<User> userStream = userRepository.getAllUsers();
 *     BackgroundTask.<SomeService, User>enqueue(userStream, (x, user) -> x.doWork("do some work for user " + user.getId()));
 * }</pre>
 * <p>
 * or
 * <pre>{@code
 *      Stream<User> userStream = userRepository.getAllUsers();
 *      taskScheduler.<SomeService, User>enqueue(userStream, (x, user) -> x.doWork("do some work for user " + user.getId()));
 * }</pre>
 * <p>
 * This functional interface allows you to enqueue background tasks for each item in the stream without having an actual instance available
 * of your service.
 * While processing, Carrot will lookup the actual service in the IoC container or create a new instance using the default constructor.
 *
 * @param <S> Your service on which you want to call a background task method.
 * @param <T> The item returned by the Stream
 */
@FunctionalInterface
public interface IocTaskLambdaFromStream<S, T> extends CarrotTask {

    void accept(S service, T item) throws Exception;
}
