package cn.boboweike.carrot.tasks.lambdas;

/**
 * This is a functional interface which represents a lambda that will be parsed by Carrot.
 * You <strong>may not create an actual instance of this class</strong>, instead you use it as follows:
 *
 * <pre>{@code
 *
 *     &commat;Inject
 *     MyService myService;
 *
 *     BackgroundTask.enqueue(myService -&gt; myService.doWork("some argument"))
 * }</pre>
 * <p>
 * or
 * <pre>{@code
 *
 *     &commat;Inject
 *     MyService myService;
 *
 *     taskScheduler.enqueue(myService -&gt; myService.doWork("some argument"))
 * }</pre>
 * <p>
 * This functional interface allows you to enqueue background tasks while having an actual instance available of your service.
 * While processing, Carrot will lookup the actual service in the IoC container or create a new instance using the default constructor.
 */
@FunctionalInterface
public interface TaskLambda extends CarrotTask {

    void run() throws Exception;
}
