package cn.boboweike.carrot.tasks.lambdas;

/**
 * This is a functional interface which allows you to schedule tasks based on a Stream and a lambda that will be parsed by Carrot.
 * You <strong>may not create an actual instance of this class</strong>, instead you use it as follows:
 *
 * <pre>{@code
 *
 *     &commat;Inject
 *     MyService myService;
 *
 *     Stream<User> userStream = userRepository.getAllUsers();
 *     BackgroundTask.enqueue(userStream, (user) -> myService.doWork("do some work for user " + user.getId()));
 * }</pre>
 * <p>
 * or
 * <pre>{@code
 *
 *      &commat;Inject
 *      MyService myService;
 *
 *      Stream<User> userStream = userRepository.getAllUsers();
 *      taskScheduler.enqueue(userStream, (user) -> myService.doWork("do some work for user " + user.getId()));
 * }</pre>
 * <p>
 * This functional interface allows you to enqueue background tasks for each item in the stream while having an actual instance available
 * of your service.
 * While processing, Carrot will lookup the actual service in the IoC container or create a new instance using the default constructor.
 *
 * @param <T> The item returned by the Stream
 */
@FunctionalInterface
public interface TaskLambdaFromStream<T> extends CarrotTask {

    void accept(T item) throws Exception;
}
