package cn.boboweike.carrot.tasks.lambdas;

/**
 * Classes implementing this interface can be used to enqueue a Carrot Task and will be used as the
 * argument for the actual {@link TaskRequestHandler}.
 *
 * <strong>Make sure that your {@code TaskRequest} class implementation can be serialized by your chosen Json library.</strong>
 * You will need a default no-arg constructor for deserialization.
 * <p>
 * While processing, Carrot will lookup the actual {@link TaskRequestHandler} in the IoC container or create a
 * new instance using the default constructor. Next, it will call the {@code run} method and pass it TaskRequest as argument.
 */
public interface TaskRequest extends CarrotTask {

    Class<? extends TaskRequestHandler> getTaskRequestHandler();

}
