package cn.boboweike.carrot.tasks.lambdas;

import cn.boboweike.carrot.server.runner.ThreadLocalTaskContext;
import cn.boboweike.carrot.tasks.context.TaskContext;

/**
 * Classes implementing this interface will handle the actual {@link TaskRequest}.
 *
 * @param <T> A TaskRequest implementation that can have extra fields and methods to be used by the {@code TaskRequestHandler}.
 */
public interface TaskRequestHandler<T extends TaskRequest> {

    /**
     * The actual task processing to perform.
     * @param taskRequest the {@link TaskRequest} to be processed
     * @throws Exception if an error occurs during the processing, Carrot will automatically retry the task.
     */
    void run(T taskRequest) throws Exception;

    /**
     * Gives access to the TaskContext for the current task in a thread-safe manner. It will be available only during the {@link #run(TaskRequest)} method.
     * @return the {@link TaskContext} for the current Task
     */
    default TaskContext taskContext() {
        return ThreadLocalTaskContext.getTaskContext();
    }
}