package cn.boboweike.carrot.tasks.mappers;

import cn.boboweike.carrot.tasks.Task;
import org.slf4j.MDC;

import java.util.Map;
import java.util.stream.Collectors;

public class MDCMapper {

    public static final String CARROT_MDC_KEY = "mdc";

    public static void saveMDCContextToTask(Task task) {
        Map<String, String> mdcContext = MDC.getCopyOfContextMap();
        if(mdcContext == null) return;
        mdcContext.forEach((key, value) -> task.getMetadata().put(CARROT_MDC_KEY + "-" + key, value));
    }

    public static void loadMDCContextFromTask(Task task) {
        Map<String, Object> taskMetadata = task.getMetadata();
        Map<String, String> mdcContextMap = taskMetadata.entrySet().stream()
                .filter(entry -> entry.getKey().startsWith(CARROT_MDC_KEY + "-"))
                .collect(Collectors.toMap(entry -> entry.getKey().substring(4), entry -> entry.getValue().toString()));
        MDC.setContextMap(mdcContextMap);
    }

}