package cn.boboweike.carrot.tasks.states;

import java.time.Instant;

@SuppressWarnings({"FieldMayBeFinal", "CanBeFinal"}) // because of JSON-B
public abstract class AbstractTaskState implements TaskState {

    private final StateName state;
    private Instant createdAt;

    protected AbstractTaskState(StateName state) {
        this.state = state;
        this.createdAt = Instant.now();
    }

    @Override
    public StateName getName() {
        return state;
    }

    @Override
    public Instant getCreatedAt() {
        return createdAt;
    }

    @Override
    public Instant getUpdatedAt() {
        return getCreatedAt();
    }
}
