package cn.boboweike.carrot.tasks.states;

import cn.boboweike.carrot.tasks.RecurringTask;

import java.time.Instant;

@SuppressWarnings("FieldMayBeFinal") // because of JSON-B
public class ScheduledState extends AbstractTaskState {

    private Instant scheduledAt;
    private String recurringTaskId;
    private String reason;

    protected ScheduledState() { // for json deserialization
        this(null);
    }

    public ScheduledState(Instant scheduledAt) {
        this(scheduledAt, (String) null);
    }

    public ScheduledState(Instant scheduledAt, RecurringTask recurringTask) {
        this(scheduledAt, "Scheduled by recurring task '" + recurringTask.getTaskName() + "'");
        this.recurringTaskId = recurringTask.getId();
    }

    public ScheduledState(Instant scheduledAt, String reason) {
        super(StateName.SCHEDULED);
        this.scheduledAt = scheduledAt;
        this.reason = reason;
    }

    public Instant getScheduledAt() {
        return scheduledAt;
    }

    public String getRecurringTaskId() {
        return recurringTaskId;
    }

    public String getReason() {
        return reason;
    }
}

