package cn.boboweike.carrot.utils.mapper.gson;

import cn.boboweike.carrot.tasks.TaskParameter;
import cn.boboweike.carrot.tasks.TaskParameterNotDeserializableException;
import cn.boboweike.carrot.utils.reflection.ReflectionUtils;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

import java.lang.reflect.Type;

import static cn.boboweike.carrot.utils.mapper.JsonMapperUtils.Json.FIELD_ACTUAL_CLASS_NAME;
import static cn.boboweike.carrot.utils.mapper.JsonMapperUtils.Json.FIELD_CLASS_NAME;
import static cn.boboweike.carrot.utils.mapper.JsonMapperUtils.getActualClassName;

public class TaskParameterDeserializer implements JsonDeserializer<TaskParameter> {

    @Override
    public TaskParameter deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext context) {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        String taskParameterMethodType = jsonObject.get(FIELD_CLASS_NAME).getAsString();
        String taskParameterActualType = jsonObject.has(FIELD_ACTUAL_CLASS_NAME) ? jsonObject.get(FIELD_ACTUAL_CLASS_NAME).getAsString() : null;
        try {
            return new TaskParameter(taskParameterMethodType, deserializeToObject(context, getActualClassName(taskParameterMethodType, taskParameterActualType), jsonObject.get("object")));
        } catch (Exception e) {
            return new TaskParameter(new TaskParameterNotDeserializableException(getActualClassName(taskParameterMethodType, taskParameterActualType), e.getMessage()));
        }
    }

    private Object deserializeToObject(JsonDeserializationContext context, String type, JsonElement jsonElement) {
        return context.deserialize(jsonElement, ReflectionUtils.toClass(type));
    }
}
