package cn.boboweike.carrot.utils.mapper.jackson.modules;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import cn.boboweike.carrot.tasks.TaskParameter;

import java.io.IOException;

public class TaskParameterSerializer extends StdSerializer<TaskParameter> {

    protected TaskParameterSerializer() {
        super(TaskParameter.class);
    }

    @Override
    public void serialize(TaskParameter taskParameter, JsonGenerator jgen, SerializerProvider serializerProvider) throws IOException {
        jgen.writeStartObject();
        jgen.writeStringField("className", taskParameter.getClassName());
        jgen.writeStringField("actualClassName", taskParameter.getActualClassName());
        jgen.writeObjectField("object", taskParameter.getObject());
        jgen.writeEndObject();
    }

}