package cn.boboweike.carrot.utils.reflection.autobox;

import cn.boboweike.carrot.utils.reflection.ReflectionUtils;

import java.util.Arrays;
import java.util.List;

public class Autoboxer {

    private static final List<TypeAutoboxer> autoboxers = Arrays.asList(
            new BooleanTypeAutoboxer(),
            new InstantTypeAutoboxer(),
            new IntegerTypeAutoboxer(),
            new LongTypeAutoboxer(),
            new DoubleTypeAutoboxer(),
            new FloatTypeAutoboxer(),
            new StringTypeAutoboxer(),
            new UUIDTypeAutoboxer(),
            new EnumAutoboxer(),
            new DurationTypeAutoboxer()
    );

    private Autoboxer() {

    }

    @SuppressWarnings("unchecked")
    public static <T> T autobox(Object value, Class<T> type) {
        if (value == null) return null;
        if (type.isAssignableFrom(value.getClass())) {
            return ReflectionUtils.cast(value);
        }

        return ReflectionUtils.cast(autoboxers.stream()
                .filter(autoboxer -> autoboxer.supports(type))
                .findFirst()
                .map(autoboxer -> autoboxer.autobox(value, type))
                .orElseThrow(() -> new UnsupportedOperationException(String.format("Cannot autobox %s of type %s to %s", value, value.getClass().getName(), type.getName()))));

    }
}
