package cn.boboweike.carrot.utils.reflection.autobox;

import cn.boboweike.carrot.utils.reflection.ReflectionUtils;

import java.math.BigDecimal;

public class BooleanTypeAutoboxer implements TypeAutoboxer<Boolean> {
    @Override
    public boolean supports(Class<?> type) {
        return Boolean.class.equals(type) || boolean.class.equals(type);
    }

    @Override
    public Boolean autobox(Object value, Class<Boolean> type) {
        if (value instanceof Boolean) {
            return (Boolean) value;
        } else if (value instanceof BigDecimal) {
            return ReflectionUtils.cast(!BigDecimal.ZERO.equals(value));
        } else if (value instanceof Integer) {
            return ReflectionUtils.cast(((Integer) value) != 0);
        }
        throw new UnsupportedOperationException(String.format("Cannot autobox %s of type %s to %s", value, value.getClass().getName(), Boolean.class.getName()));
    }
}
