package cn.boboweike.carrot.utils.reflection.autobox;

import cn.boboweike.carrot.utils.reflection.ReflectionUtils;

import java.math.BigDecimal;

public class DoubleTypeAutoboxer implements TypeAutoboxer<Double> {
    @Override
    public boolean supports(Class<?> type) {
        return double.class.equals(type) || Double.class.equals(type);
    }

    @Override
    public Double autobox(Object value, Class<Double> type) {
        if (value instanceof Double) {
            return ReflectionUtils.cast(value);
        } else if (value instanceof BigDecimal) {
            return ReflectionUtils.cast(((BigDecimal) value).doubleValue());
        } else if (value instanceof Integer) {
            return Double.valueOf((Integer) value);
        }
        throw new UnsupportedOperationException(String.format("Cannot autobox %s of type %s to %s", value, value.getClass().getName(), Double.class.getName()));
    }
}