package cn.boboweike.carrot.utils.reflection.autobox;

import cn.boboweike.carrot.utils.reflection.ReflectionUtils;

import java.math.BigDecimal;

public class FloatTypeAutoboxer implements TypeAutoboxer<Float> {
    @Override
    public boolean supports(Class<?> type) {
        return float.class.equals(type) || Float.class.equals(type);
    }

    @Override
    public Float autobox(Object value, Class<Float> type) {
        if (value instanceof Float) {
            return ReflectionUtils.cast(value);
        } else if (value instanceof BigDecimal) {
            return ReflectionUtils.cast(((BigDecimal) value).floatValue());
        } else if (value instanceof String) {
            return ReflectionUtils.cast(Long.valueOf((String) value));
        }
        throw new UnsupportedOperationException(String.format("Cannot autobox %s of type %s to %s", value, value.getClass().getName(), Long.class.getName()));
    }
}
