package cn.boboweike.carrot.utils.reflection.autobox;

import cn.boboweike.carrot.utils.reflection.ReflectionUtils;

import java.math.BigDecimal;

public class IntegerTypeAutoboxer implements TypeAutoboxer<Integer> {
    @Override
    public boolean supports(Class<?> type) {
        return int.class.equals(type) || Integer.class.equals(type);
    }

    @Override
    public Integer autobox(Object value, Class<Integer> type) {
        if (value instanceof Integer) {
            return ReflectionUtils.cast(value);
        } else if (value instanceof BigDecimal) {
            return ReflectionUtils.cast(((BigDecimal) value).intValue());
        } else if (value instanceof String) {
            return ReflectionUtils.cast(Integer.valueOf((String) value));
        } else if (value instanceof Long) {
            return ReflectionUtils.cast(((Long) value).intValue());
        }
        throw new UnsupportedOperationException(String.format("Cannot autobox %s of type %s to %s", value, value.getClass().getName(), Integer.class.getName()));
    }
}