package cn.boboweike.carrot.utils.reflection.autobox;

import cn.boboweike.carrot.utils.reflection.ReflectionUtils;

import java.math.BigDecimal;

public class LongTypeAutoboxer implements TypeAutoboxer<Long> {
    @Override
    public boolean supports(Class<?> type) {
        return long.class.equals(type) || Long.class.equals(type);
    }

    @Override
    public Long autobox(Object value, Class<Long> type) {
        if (value instanceof Long) {
            return ReflectionUtils.cast(value);
        } else if (value instanceof BigDecimal) {
            return ReflectionUtils.cast(((BigDecimal) value).longValue());
        } else if (value instanceof Integer) {
            return ReflectionUtils.cast(Long.valueOf((Integer) value));
        } else if (value instanceof String) {
            return ReflectionUtils.cast(Long.valueOf((String) value));
        }
        throw new UnsupportedOperationException(String.format("Cannot autobox %s of type %s to %s", value, value.getClass().getName(), Long.class.getName()));
    }
}

