package cn.boboweike.carrot.utils.reflection.autobox;

import cn.boboweike.carrot.utils.reflection.ReflectionUtils;

import java.sql.Clob;
import java.sql.SQLException;

import static cn.boboweike.carrot.CarrotException.shouldNotHappenException;

public class StringTypeAutoboxer implements TypeAutoboxer<String> {
    @Override
    public boolean supports(Class<?> type) {
        return String.class.equals(type);
    }

    @Override
    public String autobox(Object value, Class<String> type) {
        if (value instanceof String) {
            return (String) value;
        } else if (value instanceof Clob) {
            try {
                Clob clob = (Clob) value;
                return ReflectionUtils.cast(clob.getSubString(1, (int) clob.length()));
            } catch (SQLException e) {
                throw shouldNotHappenException(e);
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot autobox %s of type %s to %s", value, value.getClass().getName(), String.class.getName()));
    }
}
