/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.read.ListAppender;
import java.util.List;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.ListAssert;
import org.mockito.internal.util.reflection.Whitebox;

public class LoggerAssert
extends AbstractAssert<LoggerAssert, ListAppender<ILoggingEvent>> {
    Condition<ILoggingEvent> debugLogs = new Condition(e -> e.getLevel().equals(Level.DEBUG), "Debug logs", new Object[0]);
    Condition<ILoggingEvent> infoLogs = new Condition(e -> e.getLevel().equals(Level.INFO), "Info logs", new Object[0]);
    Condition<ILoggingEvent> warningLogs = new Condition(e -> e.getLevel().equals(Level.WARN), "Warning logs", new Object[0]);
    Condition<ILoggingEvent> errorLogs = new Condition(e -> e.getLevel().equals(Level.ERROR), "Error logs", new Object[0]);
    Condition<ILoggingEvent> errorLogWithMessage = new Condition(e -> e.getLevel().equals(Level.ERROR), "Error logs", new Object[0]);

    private LoggerAssert(ListAppender<ILoggingEvent> listAppender) {
        super(listAppender, LoggerAssert.class);
    }

    public static ListAppender<ILoggingEvent> initFor(Object object) {
        ListAppender listAppender = new ListAppender();
        listAppender.start();
        Logger logger = (Logger)Whitebox.getInternalState(object, "LOGGER");
        logger.setLevel(Level.DEBUG);
        logger.addAppender((Appender)listAppender);
        return listAppender;
    }

    public static LoggerAssert assertThat(ListAppender<ILoggingEvent> logger) {
        return new LoggerAssert(logger);
    }

    public LoggerAssert hasNoLogMessages() {
        Assertions.assertThat((List)((ListAppender)this.actual).list).isEmpty();
        return this;
    }

    public LoggerAssert hasNoDebugLogMessages() {
        Assertions.assertThat((List)((ListAppender)this.actual).list).doNotHave(this.logsWithLevel(Level.DEBUG));
        return this;
    }

    public LoggerAssert hasNoInfoLogMessages() {
        Assertions.assertThat((List)((ListAppender)this.actual).list).doNotHave(this.logsWithLevel(Level.INFO));
        return this;
    }

    public LoggerAssert hasNoWarnLogMessages() {
        Assertions.assertThat((List)((ListAppender)this.actual).list).doNotHave(this.logsWithLevel(Level.WARN));
        return this;
    }

    public LoggerAssert hasNoErrorLogMessages() {
        Assertions.assertThat((List)((ListAppender)this.actual).list).doNotHave(this.logsWithLevel(Level.ERROR));
        return this;
    }

    public LoggerAssert hasErrorLogMessage(Class<?> clazz, String message) {
        ((ListAssert)Assertions.assertThat((List)((ListAppender)this.actual).list).have(this.errorLogs)).anyMatch(e -> e.getLevel().equals(Level.ERROR) && e.getLoggerName().equals(clazz.getName()) && e.getFormattedMessage().equals(message));
        return this;
    }

    public LoggerAssert hasErrorMessage(String message) {
        Assertions.assertThat((List)((ListAppender)this.actual).list).areAtLeastOne(this.logsWithLevelAndMessage(Level.ERROR, message));
        return this;
    }

    public LoggerAssert hasNoErrorMessageContaining(String message) {
        Assertions.assertThat((List)((ListAppender)this.actual).list).areNot(this.logsWithLevelAndMessage(Level.ERROR, message));
        return this;
    }

    public LoggerAssert hasInfoMessage(String message) {
        Assertions.assertThat((List)((ListAppender)this.actual).list).areAtLeastOne(this.logsWithLevelAndMessage(Level.INFO, message));
        return this;
    }

    public LoggerAssert hasInfoMessageContaining(String message) {
        return this.hasInfoMessageContaining(message, 1);
    }

    public LoggerAssert hasInfoMessageContaining(String message, int times) {
        Assertions.assertThat((List)((ListAppender)this.actual).list).areExactly(times, this.logsWithLevelAndMessageContaining(Level.INFO, message));
        return this;
    }

    public LoggerAssert hasDebugMessageContaining(String message) {
        return this.hasDebugMessageContaining(message, 1);
    }

    public LoggerAssert hasDebugMessageContaining(String message, int times) {
        Assertions.assertThat((List)((ListAppender)this.actual).list).areExactly(times, this.logsWithLevelAndMessageContaining(Level.DEBUG, message));
        return this;
    }

    public LoggerAssert hasWarningMessageContaining(String message) {
        return this.hasWarningMessageContaining(message, 1);
    }

    public LoggerAssert hasWarningMessageContaining(String message, int times) {
        Assertions.assertThat((List)((ListAppender)this.actual).list).areExactly(times, this.logsWithLevelAndMessageContaining(Level.WARN, message));
        return this;
    }

    private Condition<ILoggingEvent> logsWithLevel(Level level) {
        return new Condition(e -> e.getLevel().equals(level), level + " logs", new Object[0]);
    }

    private Condition<ILoggingEvent> logsWithLevelAndMessage(Level level, String message) {
        return new Condition(e -> e.getLevel().equals(level) && e.toString().replace("[" + level + "] ", "").equals(message), level + " logs with message: " + message, new Object[0]);
    }

    private Condition<ILoggingEvent> logsWithLevelAndMessageContaining(Level level, String message) {
        return new Condition(e -> e.getLevel().equals(level) && e.toString().replace("[" + level + "] ", "").contains(message), level + " logs with message: " + message, new Object[0]);
    }
}

