/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.configuration;

import cn.boboweike.carrot.configuration.Carrot;
import cn.boboweike.carrot.configuration.CarrotConfiguration;
import cn.boboweike.carrot.scheduling.partition.Partitioner;
import cn.boboweike.carrot.server.TaskActivator;
import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import cn.boboweike.carrot.tasks.mappers.TaskMapper;
import cn.boboweike.carrot.utils.mapper.JsonMapper;
import cn.boboweike.carrot.utils.mapper.gson.GsonJsonMapper;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.internal.util.reflection.Whitebox;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class CarrotConfigurationTest {
    @Mock
    TaskActivator taskActivator;
    @Mock
    PartitionedStorageProvider storageProvider;
    @Mock
    Partitioner partitioner;
    @Captor
    ArgumentCaptor<TaskMapper> taskMapperCaptor;

    @AfterEach
    void tearDown() {
        Carrot.destroy();
    }

    @Test
    void jsonMapperCanBeConfigured() {
        GsonJsonMapper jsonMapper = new GsonJsonMapper();
        Carrot.configure().useJsonMapper((JsonMapper)jsonMapper).useStorageProvider(this.storageProvider).initialize();
        ((PartitionedStorageProvider)Mockito.verify((Object)this.storageProvider)).setTaskMapper((TaskMapper)this.taskMapperCaptor.capture());
        TaskMapper taskMapper = (TaskMapper)this.taskMapperCaptor.getValue();
        Assertions.assertThat((Object)((JsonMapper)Whitebox.getInternalState(taskMapper, "jsonMapper"))).isEqualTo((Object)jsonMapper);
    }

    @Test
    void ifTaskActivatorIsAddedAfterBackgroundTaskServer() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Carrot.configure().useStorageProvider(this.storageProvider).useBackgroundTaskServer().useTaskActivator(this.taskActivator)).isInstanceOf(IllegalStateException.class)).hasMessage("Please configure the TaskActivator before the BackgroundTaskServer.");
    }

    @Test
    void ifPartitionerIsAddedBeforeStorageProvider() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Carrot.configure().usePartitioner(this.partitioner).useStorageProvider(this.storageProvider).useBackgroundTaskServer()).isInstanceOf(IllegalStateException.class)).hasMessage("Please configure the PartitionedStorageProvider before the Partitioner.");
    }

    @Test
    void backgroundTaskServerThrowsExceptionIfNoStorageProviderIsAvailable() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Carrot.configure().useBackgroundTaskServer()).isInstanceOf(IllegalArgumentException.class)).hasMessage("A StorageProvider is required to use a BackgroundTaskServer. Please see the documentation on how to setup a task StorageProvider.");
    }

    @Test
    void backgroundTaskServerIsNotInstantiatedIfGuardIsFalse() {
        Assertions.assertThatCode(() -> Carrot.configure().useBackgroundTaskServerIf(false)).doesNotThrowAnyException();
    }

    @Test
    void backgroundTaskServerGivenWorkerCountIsUsed() {
        Carrot.configure().useStorageProvider(this.storageProvider).useBackgroundTaskServer(4).initialize();
        Assertions.assertThat((int)Carrot.getBackgroundTaskServer().getServerStatus().getWorkerPoolSize()).isEqualTo(4);
    }

    @Test
    void dashboardThrowsExceptionIfNoStorageProviderIsAvailable() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> Carrot.configure().useDashboard()).isInstanceOf(IllegalArgumentException.class)).hasMessage("A StorageProvider is required to use a CarrotDashboardWebServer. Please see the documentation on how to setup a task StorageProvider.");
    }

    @Test
    void dashboardCanBeConfigured() {
        Assertions.assertThatCode(() -> Carrot.configure().useStorageProvider(this.storageProvider).useDashboard()).doesNotThrowAnyException();
    }

    @Test
    void dashboardIsNotStartedIfGuardIsFalse() {
        Assertions.assertThatCode(() -> Carrot.configure().useDashboardIf(false)).doesNotThrowAnyException();
    }

    @Test
    void dashboardPortCanBeConfigured() {
        CarrotConfiguration configuration = Carrot.configure().useStorageProvider(this.storageProvider).useDashboard(9000);
        Assertions.assertThat((Object)configuration.dashboardWebServer).isNotNull();
        Assertions.assertThat((int)((Integer)Whitebox.getInternalState(configuration.dashboardWebServer, "port"))).isEqualTo(9000);
    }

    @Test
    void initializeGivesAccessToTaskSchedulerAndTaskRequestScheduler() {
        CarrotConfiguration.CarrotConfigurationResult configurationResult = Carrot.configure().useStorageProvider(this.storageProvider).initialize();
        Assertions.assertThat((Object)configurationResult.getTaskScheduler()).isNotNull();
        Assertions.assertThat((Object)configurationResult.getTaskRequestScheduler()).isNotNull();
    }
}

