/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.configuration;

import cn.boboweike.carrot.configuration.CarrotMicroMeterIntegration;
import cn.boboweike.carrot.server.BackgroundTaskServer;
import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import cn.boboweike.carrot.storage.TaskStats;
import cn.boboweike.carrot.storage.TaskStatsData;
import cn.boboweike.carrot.storage.listeners.StorageProviderChangeListener;
import cn.boboweike.carrot.storage.metrics.StorageProviderMetricsBinder;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
public class CarrotMicroMeterIntegrationTest {
    @Mock
    private MeterRegistry meterRegistry;
    @Mock
    private PartitionedStorageProvider storageProvider;
    @Mock
    private BackgroundTaskServer backgroundTaskServer;

    @Test
    void testWithStorageProviderOnly() {
        CarrotMicroMeterIntegration carrotMicroMeterIntegration = new CarrotMicroMeterIntegration(this.meterRegistry);
        TaskStatsData taskStatsData = new TaskStatsData();
        taskStatsData.setOverallTaskStats(TaskStats.empty());
        Mockito.when((Object)this.storageProvider.getTaskStatsData()).thenReturn((Object)taskStatsData);
        carrotMicroMeterIntegration.initialize(this.storageProvider, null);
        ((PartitionedStorageProvider)Mockito.verify((Object)this.storageProvider)).getTaskStatsData();
        ((PartitionedStorageProvider)Mockito.verify((Object)this.storageProvider)).addTaskStorageOnChangeListener((StorageProviderChangeListener)ArgumentMatchers.any(StorageProviderMetricsBinder.class));
        ((MeterRegistry)Mockito.verify((Object)this.meterRegistry, (VerificationMode)Mockito.times((int)7))).gauge((String)ArgumentMatchers.any(String.class), (Iterable)ArgumentMatchers.any(Iterable.class), (Number)((AtomicLong)ArgumentMatchers.any(AtomicLong.class)));
        Assertions.assertThatCode(() -> ((CarrotMicroMeterIntegration)carrotMicroMeterIntegration).close()).doesNotThrowAnyException();
    }

    @Test
    void testWithStorageProviderAndBackgroundTaskServerOnly() {
        CarrotMicroMeterIntegration carrotMicroMeterIntegration = new CarrotMicroMeterIntegration(this.meterRegistry);
        Mockito.when((Object)this.meterRegistry.more()).thenReturn((Object)((MeterRegistry.More)Mockito.mock(MeterRegistry.More.class)));
        TaskStatsData taskStatsData = new TaskStatsData();
        taskStatsData.setOverallTaskStats(TaskStats.empty());
        Mockito.when((Object)this.storageProvider.getTaskStatsData()).thenReturn((Object)taskStatsData);
        Mockito.when((Object)this.backgroundTaskServer.getId()).thenReturn((Object)UUID.randomUUID());
        carrotMicroMeterIntegration.initialize(this.storageProvider, this.backgroundTaskServer);
        ((PartitionedStorageProvider)Mockito.verify((Object)this.storageProvider)).getTaskStatsData();
        ((PartitionedStorageProvider)Mockito.verify((Object)this.storageProvider)).addTaskStorageOnChangeListener((StorageProviderChangeListener)ArgumentMatchers.any(StorageProviderMetricsBinder.class));
        ((MeterRegistry)Mockito.verify((Object)this.meterRegistry, (VerificationMode)Mockito.times((int)7))).gauge((String)ArgumentMatchers.any(String.class), (Iterable)ArgumentMatchers.any(Iterable.class), (Number)((AtomicLong)ArgumentMatchers.any(AtomicLong.class)));
        Assertions.assertThatCode(() -> ((CarrotMicroMeterIntegration)carrotMicroMeterIntegration).close()).doesNotThrowAnyException();
    }
}

