/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.dashboard;

import cn.boboweike.carrot.SevereCarrotException;
import cn.boboweike.carrot.dashboard.CarrotDashboardWebServer;
import cn.boboweike.carrot.fixtures.CarrotAssertions;
import cn.boboweike.carrot.fixtures.dashboard.server.http.client.TeenyHttpClient;
import cn.boboweike.carrot.fixtures.storage.BackgroundTaskServerStatusTestBuilder;
import cn.boboweike.carrot.fixtures.tasks.RecurringTaskTestBuilder;
import cn.boboweike.carrot.fixtures.tasks.TaskDetailsTestBuilder;
import cn.boboweike.carrot.fixtures.tasks.TaskTestBuilder;
import cn.boboweike.carrot.fixtures.utils.FreePortFinder;
import cn.boboweike.carrot.storage.BackgroundTaskServerStatus;
import cn.boboweike.carrot.storage.CarrotMetadata;
import cn.boboweike.carrot.storage.InMemoryPartitionedStorageProvider;
import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.mappers.TaskMapper;
import cn.boboweike.carrot.tasks.states.ScheduledState;
import cn.boboweike.carrot.tasks.states.StateName;
import cn.boboweike.carrot.tasks.states.TaskState;
import cn.boboweike.carrot.utils.mapper.JsonMapper;
import java.net.http.HttpResponse;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.UUID;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

abstract class CarrotDashboardWebServerTest {
    private PartitionedStorageProvider storageProvider;
    private CarrotDashboardWebServer dashboardWebServer;
    private TeenyHttpClient http;

    CarrotDashboardWebServerTest() {
    }

    abstract JsonMapper getJsonMapper();

    @BeforeEach
    void setUpWebServer() {
        JsonMapper jsonMapper = this.getJsonMapper();
        this.storageProvider = new InMemoryPartitionedStorageProvider();
        this.storageProvider.setTaskMapper(new TaskMapper(jsonMapper));
        int port = FreePortFinder.nextFreePort(8000);
        this.dashboardWebServer = new CarrotDashboardWebServer(this.storageProvider, jsonMapper, port);
        this.dashboardWebServer.start();
        this.http = new TeenyHttpClient("http://localhost:" + port);
    }

    @AfterEach
    void stopWebServer() {
        this.dashboardWebServer.stop();
        this.storageProvider.close();
    }

    @Test
    void testGetTaskById_ForEnqueuedTask() {
        Task task = TaskTestBuilder.anEnqueuedTask().build();
        Task savedTask = this.storageProvider.save(task);
        HttpResponse<String> getResponse = this.http.get("/api/tasks/%s", savedTask.getId());
        CarrotAssertions.assertThat(getResponse).hasStatusCode(200);
    }

    @Test
    void testGetTaskById_ForFailedTask() {
        Task task = TaskTestBuilder.aFailedTaskWithRetries().build();
        Task savedTask = this.storageProvider.save(task);
        HttpResponse<String> getResponse = this.http.get("/api/tasks/%s", savedTask.getId());
        CarrotAssertions.assertThat(getResponse).hasStatusCode(200).hasSameJsonBodyAsResource("/dashboard/api/getTaskById_ForFailedTask.json");
    }

    @Test
    void testRequeueTask() {
        Task task = TaskTestBuilder.aFailedTaskWithRetries().build();
        Task savedTask = this.storageProvider.save(task);
        HttpResponse<String> deleteResponse = this.http.post("/api/tasks/%s/requeue", savedTask.getId());
        CarrotAssertions.assertThat(deleteResponse).hasStatusCode(204);
        CarrotAssertions.assertThat(this.storageProvider.getTaskById(task.getId())).hasState(StateName.ENQUEUED);
    }

    @Test
    void testDeleteTask() {
        Task task = TaskTestBuilder.aFailedTaskWithRetries().build();
        Task savedTask = this.storageProvider.save(task);
        HttpResponse<String> deleteResponse = this.http.delete("/api/tasks/%s", savedTask.getId());
        CarrotAssertions.assertThat(deleteResponse).hasStatusCode(204);
        HttpResponse<String> getResponse = this.http.get("/api/tasks/%s", savedTask.getId());
        CarrotAssertions.assertThat(getResponse).hasStatusCode(200);
        CarrotAssertions.assertThat(this.storageProvider.getTaskById(savedTask.getId())).hasState(StateName.DELETED);
    }

    @Test
    void testGetTaskById_TaskNotFoundReturns404() {
        HttpResponse<String> getResponse = this.http.get("/api/tasks/%s", UUID.randomUUID());
        CarrotAssertions.assertThat(getResponse).hasStatusCode(404);
    }

    @Test
    void testFindTasksByState() {
        this.storageProvider.save(TaskTestBuilder.anEnqueuedTask().build());
        HttpResponse<String> getResponse = this.http.get("/api/tasks?state=ENQUEUED");
        CarrotAssertions.assertThat(getResponse).hasStatusCode(200).hasSameJsonBodyAsResource("/dashboard/api/findTasksByState.json");
    }

    @Test
    void testGetProblems() {
        this.storageProvider.save(TaskTestBuilder.aTask().withTaskDetails(TaskDetailsTestBuilder.methodThatDoesNotExistTaskDetails()).withState((TaskState)new ScheduledState(Instant.now().plus(1L, ChronoUnit.DAYS))).build());
        HttpResponse<String> getResponse = this.http.get("/api/problems");
        CarrotAssertions.assertThat(getResponse).hasStatusCode(200).hasSameJsonBodyAsResource("/dashboard/api/problems-task-not-found.json");
    }

    @Test
    void testDeleteProblem() {
        this.storageProvider.saveMetadata(new CarrotMetadata(SevereCarrotException.class.getSimpleName(), "some id", "some value"));
        HttpResponse<String> getResponseBeforeDelete = this.http.get("/api/problems");
        CarrotAssertions.assertThat(getResponseBeforeDelete).hasStatusCode(200).hasSameJsonBodyAsResource("/dashboard/api/problems-severe-carrot-problem.json");
        this.http.delete("/api/problems/severe-carrot-exception", new Object[0]);
        HttpResponse<String> getResponseAfterDelete = this.http.get("/api/problems");
        CarrotAssertions.assertThat(getResponseAfterDelete).hasStatusCode(200).hasJsonBody("[]");
    }

    @Test
    void testGetRecurringTasks() {
        this.storageProvider.saveRecurringTask(RecurringTaskTestBuilder.aDefaultRecurringTask().withId("recurring-task-1").withName("Import sales data").build());
        this.storageProvider.saveRecurringTask(RecurringTaskTestBuilder.aDefaultRecurringTask().withId("recurring-task-2").withName("Generate sales reports").build());
        HttpResponse<String> getResponse = this.http.get("/api/recurring-tasks");
        CarrotAssertions.assertThat(getResponse).hasStatusCode(200).hasSameJsonBodyAsResource("/dashboard/api/getRecurringTasks.json");
    }

    @Test
    void testDeleteRecurringTask() {
        this.storageProvider.saveRecurringTask(RecurringTaskTestBuilder.aDefaultRecurringTask().withId("recurring-task-1").withName("Import sales data").build());
        this.storageProvider.saveRecurringTask(RecurringTaskTestBuilder.aDefaultRecurringTask().withId("recurring-task-2").withName("Generate sales reports").build());
        HttpResponse<String> deleteResponse = this.http.delete("/api/recurring-tasks/%s", "recurring-task-1");
        CarrotAssertions.assertThat(deleteResponse).hasStatusCode(204);
        CarrotAssertions.assertThat((List)this.storageProvider.getRecurringTasks()).hasSize(1);
    }

    @Test
    void testGetBackgroundTaskServers() {
        BackgroundTaskServerStatus serverStatus = BackgroundTaskServerStatusTestBuilder.aDefaultBackgroundTaskServerStatus().withIsStarted().build();
        this.storageProvider.announceBackgroundTaskServer(serverStatus);
        HttpResponse<String> getResponse = this.http.get("/api/servers");
        CarrotAssertions.assertThat(getResponse).hasStatusCode(200).hasSameJsonBodyAsResource("/dashboard/api/getBackgroundTaskServers.json");
    }
}

