/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.dashboard;

import cn.boboweike.carrot.dashboard.CarrotSseHandler;
import cn.boboweike.carrot.storage.InMemoryPartitionedStorageProvider;
import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import cn.boboweike.carrot.storage.listeners.StorageProviderChangeListener;
import cn.boboweike.carrot.utils.mapper.JsonMapper;
import cn.boboweike.carrot.utils.mapper.jackson.JacksonJsonMapper;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Timer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.internal.util.reflection.Whitebox;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
class CarrotSseHandlerTest {
    private CarrotSseHandler carrotSseHandler;
    private InMemoryPartitionedStorageProvider storageProvider;

    CarrotSseHandlerTest() {
    }

    @BeforeEach
    void setUpSseHandler() {
        this.storageProvider = (InMemoryPartitionedStorageProvider)Mockito.spy((Object)new InMemoryPartitionedStorageProvider());
        this.carrotSseHandler = new CarrotSseHandler((PartitionedStorageProvider)this.storageProvider, (JsonMapper)new JacksonJsonMapper());
    }

    @Test
    void onCloseOfSseHandlersAllSseExchangesAreClosed() throws IOException {
        HttpExchange httpExchange1 = this.createHttpExchangeMock();
        Mockito.when((Object)httpExchange1.getRequestURI()).thenReturn((Object)URI.create("/sse/taskstats"));
        HttpExchange httpExchange2 = this.createHttpExchangeMock();
        Mockito.when((Object)httpExchange2.getRequestURI()).thenReturn((Object)URI.create("/sse/taskstats"));
        this.carrotSseHandler.handle(httpExchange1);
        this.carrotSseHandler.handle(httpExchange2);
        Timer timerBeforeClosingSseHandler = (Timer)Whitebox.getInternalState(this.storageProvider, "timer");
        Assertions.assertThat((Object)timerBeforeClosingSseHandler).isNotNull();
        this.carrotSseHandler.close();
        ((InMemoryPartitionedStorageProvider)Mockito.verify((Object)this.storageProvider, (VerificationMode)Mockito.times((int)2))).removeTaskStorageOnChangeListener((StorageProviderChangeListener)ArgumentMatchers.any());
        Timer timerAfterClosingSseHandler = (Timer)Whitebox.getInternalState(this.storageProvider, "timer");
        Assertions.assertThat((Object)timerAfterClosingSseHandler).isNull();
    }

    private HttpExchange createHttpExchangeMock() {
        HttpExchange httpExchange = (HttpExchange)Mockito.mock(HttpExchange.class);
        Mockito.when((Object)httpExchange.getResponseBody()).thenReturn((Object)new ByteArrayOutputStream());
        Mockito.when((Object)httpExchange.getResponseHeaders()).thenReturn((Object)new Headers());
        return httpExchange;
    }
}

