/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.dashboard;

import cn.boboweike.carrot.SevereCarrotException;
import cn.boboweike.carrot.configuration.Carrot;
import cn.boboweike.carrot.fixtures.storage.StubDataProvider;
import cn.boboweike.carrot.fixtures.tasks.TaskDetailsTestBuilder;
import cn.boboweike.carrot.fixtures.tasks.TaskTestBuilder;
import cn.boboweike.carrot.scheduling.BackgroundTask;
import cn.boboweike.carrot.scheduling.cron.Cron;
import cn.boboweike.carrot.server.dashboard.CpuAllocationIrregularityNotification;
import cn.boboweike.carrot.server.dashboard.DashboardNotification;
import cn.boboweike.carrot.server.dashboard.DashboardNotificationManager;
import cn.boboweike.carrot.storage.InMemoryPartitionedStorageProvider;
import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import cn.boboweike.carrot.tasks.context.TaskContext;
import cn.boboweike.carrot.tasks.lambdas.IocTaskLambda;
import cn.boboweike.carrot.tasks.mappers.TaskMapper;
import cn.boboweike.carrot.tasks.states.ScheduledState;
import cn.boboweike.carrot.tasks.states.TaskState;
import cn.boboweike.carrot.utils.diagnostics.DiagnosticsBuilder;
import cn.boboweike.carrot.utils.mapper.JsonMapper;
import cn.boboweike.carrot.utils.mapper.jackson.JacksonJsonMapper;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Timer;
import java.util.TimerTask;

public class FrontEndDevelopment {
    public static void main(String[] args) throws InterruptedException {
        InMemoryPartitionedStorageProvider storageProvider = new InMemoryPartitionedStorageProvider();
        storageProvider.setTaskMapper(new TaskMapper((JsonMapper)new JacksonJsonMapper()));
        StubDataProvider.using((PartitionedStorageProvider)storageProvider).addSomeRecurringTasks();
        storageProvider.save(TaskTestBuilder.aTask().withTaskDetails(TaskDetailsTestBuilder.classThatDoesNotExistTaskDetails()).withState((TaskState)new ScheduledState(Instant.now().plus(2L, ChronoUnit.MINUTES))).build());
        storageProvider.save(TaskTestBuilder.aTask().withTaskDetails(TaskDetailsTestBuilder.methodThatDoesNotExistTaskDetails()).withState((TaskState)new ScheduledState(Instant.now().plus(2L, ChronoUnit.MINUTES))).build());
        storageProvider.save(TaskTestBuilder.aTask().withTaskDetails(TaskDetailsTestBuilder.taskParameterThatDoesNotExistTaskDetails()).withState((TaskState)new ScheduledState(Instant.now().plus(1L, ChronoUnit.MINUTES))).build());
        Carrot.configure().useStorageProvider((PartitionedStorageProvider)storageProvider).useDashboardIf(FrontEndDevelopment.dashboardIsEnabled(args), 8000).useBackgroundTaskServer().initialize();
        BackgroundTask.scheduleRecurrently((String)"Github-75", (String)Cron.daily((int)18, (int)4), (IocTaskLambda & Serializable)x -> x.doWorkThatTakesLong(TaskContext.Null));
        BackgroundTask.scheduleRecurrently((Duration)Duration.ofMinutes(1L), (IocTaskLambda & Serializable)x -> x.doWorkThatTakesLong(TaskContext.Null));
        final DashboardNotificationManager dashboardNotificationManager = new DashboardNotificationManager(Carrot.getBackgroundTaskServer().getId(), (PartitionedStorageProvider)storageProvider);
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                dashboardNotificationManager.handle((Exception)new SevereCarrotException("A bad exception happened.", (SevereCarrotException.DiagnosticsAware)new ExceptionWithDiagnostics()));
                dashboardNotificationManager.notify((DashboardNotification)new CpuAllocationIrregularityNotification(Integer.valueOf(20)));
                System.out.println("Saved ServerCarrotException");
            }
        }, 30000L);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> Thread.currentThread().interrupt()));
        Thread.currentThread().join();
    }

    private static boolean dashboardIsEnabled(String[] args) {
        return !FrontEndDevelopment.argsContains(args, "dashboard=false");
    }

    private static boolean argsContains(String[] args, String argToSearch) {
        if (args.length == 0) {
            return false;
        }
        for (String arg : args) {
            if (!argToSearch.equalsIgnoreCase(arg)) continue;
            return true;
        }
        return false;
    }

    private static class ExceptionWithDiagnostics
    implements SevereCarrotException.DiagnosticsAware {
        private ExceptionWithDiagnostics() {
        }

        public DiagnosticsBuilder getDiagnosticsInfo() {
            return DiagnosticsBuilder.diagnostics().withTitle("Title").withLine("Text").withException((Exception)new RuntimeException());
        }
    }
}

