/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.dashboard.server.http;

import cn.boboweike.carrot.dashboard.server.http.ContentType;
import java.nio.file.Path;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ContentTypeTest {
    ContentTypeTest() {
    }

    @Test
    void testHtmlContentType() {
        Assertions.assertThat((String)ContentType.from((Path)Path.of("index.html", new String[0]))).isEqualTo("text/html;charset=UTF-8");
    }

    @Test
    void testTextContentType() {
        Assertions.assertThat((String)ContentType.from((Path)Path.of("index.txt", new String[0]))).isEqualTo("text/plain;charset=UTF-8");
    }

    @Test
    void testJsonContentType() {
        Assertions.assertThat((String)ContentType.from((Path)Path.of("products.json", new String[0]))).isEqualTo("application/json");
    }

    @Test
    void testJavascriptContentType() {
        Assertions.assertThat((String)ContentType.from((Path)Path.of("javascript.js", new String[0]))).isEqualTo("text/javascript;charset=UTF-8");
    }

    @Test
    void testCssContentType() {
        Assertions.assertThat((String)ContentType.from((Path)Path.of("stylesheet.css", new String[0]))).isEqualTo("text/css;charset=UTF-8");
    }

    @Test
    void testPngContentType() {
        Assertions.assertThat((String)ContentType.from((Path)Path.of("image.png", new String[0]))).isEqualTo("image/png");
    }

    @Test
    void testIcoContentType() {
        Assertions.assertThat((String)ContentType.from((Path)Path.of("image.ico", new String[0]))).isEqualTo("image/x-icon");
    }

    @Test
    void testJavascriptDebugMapsContentType() {
        Assertions.assertThat((String)ContentType.from((Path)Path.of("debug.map", new String[0]))).isEqualTo("application/octet-stream");
    }

    @Test
    void testUnknownContentType() {
        Assertions.assertThatThrownBy(() -> ContentType.from((Path)Path.of("un.known", new String[0]))).isInstanceOf(IllegalArgumentException.class);
    }
}

