/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.dashboard.server.http;

import cn.boboweike.carrot.dashboard.server.http.StaticFileHttpHandler;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class StaticFileHttpHandlerTest {
    @Mock
    HttpExchange httpExchange;
    @Mock
    Headers headers;
    StaticFileHttpHandler staticFileHttpHandler;

    @BeforeEach
    void setupHttpExchange() {
        Mockito.lenient().when((Object)this.httpExchange.getResponseHeaders()).thenReturn((Object)this.headers);
        Mockito.lenient().when((Object)this.httpExchange.getResponseBody()).thenReturn((Object)new ByteArrayOutputStream());
        this.staticFileHttpHandler = new StaticFileHttpHandler("/dashboard", "dashboard/test/", true);
    }

    @Test
    void servesIndexHtmlIfNoFileRequested() throws IOException {
        Mockito.when((Object)this.httpExchange.getRequestURI()).thenReturn((Object)URI.create("/dashboard"));
        this.staticFileHttpHandler.handle(this.httpExchange);
        ((HttpExchange)Mockito.verify((Object)this.httpExchange)).sendResponseHeaders(200, 0L);
    }

    @Test
    void servesRequestedFile() throws IOException {
        Mockito.when((Object)this.httpExchange.getRequestURI()).thenReturn((Object)URI.create("/dashboard/test.html"));
        this.staticFileHttpHandler.handle(this.httpExchange);
        ((HttpExchange)Mockito.verify((Object)this.httpExchange)).sendResponseHeaders(200, 0L);
    }

    @Test
    void returns404IfFileNotFound() throws IOException {
        Mockito.when((Object)this.httpExchange.getRequestURI()).thenReturn((Object)URI.create("/dashboard/404.html"));
        this.staticFileHttpHandler.handle(this.httpExchange);
        ((HttpExchange)Mockito.verify((Object)this.httpExchange)).sendResponseHeaders(404, -1L);
    }
}

