/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.dashboard.server.http.url;

import cn.boboweike.carrot.dashboard.server.http.url.MatchUrl;
import cn.boboweike.carrot.dashboard.server.http.url.RequestUrl;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class MatchUrlTest {
    @Test
    void testNoMatch() {
        boolean matches = new MatchUrl("/api").matches("/dashboard");
        Assertions.assertThat((boolean)matches).isFalse();
    }

    @Test
    void testMatch() {
        boolean matches = new MatchUrl("/api/tasks").matches("/api/tasks");
        Assertions.assertThat((boolean)matches).isTrue();
    }

    @Test
    void testNoMatchWithParamsAndDifferentSize() {
        boolean matches = new MatchUrl("/api/tasks/enqueued/test").matches("/api/tasks/:state/test/extra");
        Assertions.assertThat((boolean)matches).isFalse();
    }

    @Test
    void testMatchWithParams() {
        boolean matches = new MatchUrl("/api/tasks/enqueued/test").matches("/api/tasks/:state/test");
        Assertions.assertThat((boolean)matches).isTrue();
    }

    @Test
    void testNoMatchWithParams() {
        boolean matches = new MatchUrl("/api/tasks/enqueued/wrong").matches("/api/tasks/:state/test");
        Assertions.assertThat((boolean)matches).isFalse();
    }

    @Test
    void testToRequestUrl() {
        RequestUrl requestUrl = new MatchUrl("/api/tasks/enqueued/test").toRequestUrl("/api/tasks/:state/test");
        Assertions.assertThat((String)requestUrl.param(":state")).isEqualTo("enqueued");
    }

    @Test
    void testToRequestUrlWithQueryParams() {
        RequestUrl requestUrl = new MatchUrl("/api/tasks/enqueued?offset=2").toRequestUrl("/api/tasks/:state");
        Assertions.assertThat((String)requestUrl.param(":state")).isEqualTo("enqueued");
    }
}

