/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.dashboard.server.http.url;

import cn.boboweike.carrot.dashboard.server.http.url.MatchUrl;
import cn.boboweike.carrot.dashboard.server.http.url.RequestUrl;
import cn.boboweike.carrot.storage.PageRequest;
import cn.boboweike.carrot.tasks.states.StateName;
import java.util.Map;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class RequestUrlTest {
    RequestUrlTest() {
    }

    @Test
    void testRequestUrl() {
        RequestUrl requestUrl = new MatchUrl("/api/tasks/enqueued?offset=2&limit=2").toRequestUrl("/api/tasks/:state");
        Assertions.assertThat((String)requestUrl.getUrl()).isEqualTo("/api/tasks/enqueued?offset=2&limit=2");
    }

    @Test
    void testRequestUrlParams() {
        RequestUrl requestUrl = new MatchUrl("/api/tasks/enqueued?offset=2&limit=2").toRequestUrl("/api/tasks/:state");
        Assertions.assertThat((Map)requestUrl.getParams()).containsEntry((Object)":state", (Object)"enqueued");
    }

    @Test
    void testRequestUrlParamAsUUID() {
        RequestUrl requestUrl = new MatchUrl("/api/tasks/17b2c0a0-bf6b-446a-8cea-93246675fe0c").toRequestUrl("/api/tasks/:id");
        Assertions.assertThat((Comparable)((UUID)requestUrl.param(":id", UUID.class))).isEqualTo((Object)UUID.fromString("17b2c0a0-bf6b-446a-8cea-93246675fe0c"));
    }

    @Test
    void testRequestUrlParamAsString() {
        RequestUrl requestUrl = new MatchUrl("/api/problems/some-string").toRequestUrl("/api/problems/:type");
        Assertions.assertThat((String)((String)requestUrl.param(":type", String.class))).isEqualTo("some-string");
    }

    @Test
    void testRequestUrlParamAsEnum() {
        RequestUrl requestUrl = new MatchUrl("/api/tasks/enqueued?offset=2&limit=2").toRequestUrl("/api/tasks/:state");
        Assertions.assertThat((Comparable)((StateName)requestUrl.param(":state", StateName.class))).isEqualTo((Object)StateName.ENQUEUED);
    }

    @Test
    void testRequestUrlParamAsUnknownClass() {
        RequestUrl requestUrl = new MatchUrl("/api/tasks/enqueued?offset=2&limit=2").toRequestUrl("/api/tasks/:state");
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> requestUrl.param(":state", Object.class));
    }

    @Test
    void testRequestUrlQueryParam() {
        RequestUrl requestUrl = new MatchUrl("/api/tasks/enqueued?present=2").toRequestUrl("/api/tasks/:state");
        Assertions.assertThat((String)requestUrl.queryParam("present")).isEqualTo("2");
    }

    @Test
    void testRequestUrlQueryParamWhichIsPresentUsingClass() {
        RequestUrl requestUrl = new MatchUrl("/api/tasks?state=SCHEDULED").toRequestUrl("/api/tasks");
        Assertions.assertThat((Comparable)((StateName)requestUrl.queryParam("state", StateName.class, (Object)StateName.ENQUEUED))).isEqualTo((Object)StateName.SCHEDULED);
    }

    @Test
    void testRequestUrlQueryParamWhichIsNotPresentUsingClass() {
        RequestUrl requestUrl = new MatchUrl("/api/tasks").toRequestUrl("/api/tasks");
        Assertions.assertThat((Comparable)((StateName)requestUrl.queryParam("state", StateName.class, (Object)StateName.ENQUEUED))).isEqualTo((Object)StateName.ENQUEUED);
    }

    @Test
    void testToRequestUrlWithQueryParams() {
        RequestUrl requestUrl = new MatchUrl("/api/tasks/enqueued?offset=2&limit=2&order=updatedAt:DESC").toRequestUrl("/api/tasks/:state");
        PageRequest pageRequest = (PageRequest)requestUrl.fromQueryParams(PageRequest.class);
        Assertions.assertThat((long)pageRequest.getOffset()).isEqualTo(2L);
        Assertions.assertThat((int)pageRequest.getLimit()).isEqualTo(2);
        Assertions.assertThat((String)pageRequest.getOrder()).isEqualTo("updatedAt:DESC");
    }
}

