/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.dashboard.sse;

import cn.boboweike.carrot.dashboard.sse.TaskSseExchange;
import cn.boboweike.carrot.fixtures.tasks.TaskTestBuilder;
import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import cn.boboweike.carrot.storage.listeners.StorageProviderChangeListener;
import cn.boboweike.carrot.tasks.TaskId;
import cn.boboweike.carrot.utils.mapper.JsonMapper;
import cn.boboweike.carrot.utils.mapper.jackson.JacksonJsonMapper;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class TaskSseExchangeTest {
    @Mock
    private HttpExchange httpExchange;
    @Mock
    private PartitionedStorageProvider storageProvider;
    private UUID taskId;

    @BeforeEach
    void setUp() throws URISyntaxException {
        this.taskId = UUID.randomUUID();
        Mockito.when((Object)this.httpExchange.getResponseBody()).thenReturn((Object)new ByteArrayOutputStream());
        Mockito.when((Object)this.httpExchange.getResponseHeaders()).thenReturn((Object)new Headers());
        Mockito.when((Object)this.httpExchange.getRequestURI()).thenReturn((Object)new URI("/sse/tasks/" + this.taskId));
    }

    @Test
    void sseConnectionSubscribesForTaskStates() throws IOException {
        TaskSseExchange taskSseExchange = new TaskSseExchange(this.httpExchange, this.storageProvider, (JsonMapper)new JacksonJsonMapper());
        ((PartitionedStorageProvider)Mockito.verify((Object)this.storageProvider)).addTaskStorageOnChangeListener((StorageProviderChangeListener)taskSseExchange);
    }

    @Test
    void sseConnectionParsesTaskIdCorrectly() throws IOException {
        TaskSseExchange taskSseExchange = new TaskSseExchange(this.httpExchange, this.storageProvider, (JsonMapper)new JacksonJsonMapper());
        Assertions.assertThat((Object)taskSseExchange.getTaskId()).isEqualTo((Object)new TaskId(this.taskId));
    }

    @Test
    void sseConnectionIsClosedIfTaskStateIsSucceeded() throws IOException {
        TaskSseExchange taskSseExchange = new TaskSseExchange(this.httpExchange, this.storageProvider, (JsonMapper)new JacksonJsonMapper());
        taskSseExchange.onChange(TaskTestBuilder.aSucceededTask().build());
        ((PartitionedStorageProvider)Mockito.verify((Object)this.storageProvider)).removeTaskStorageOnChangeListener((StorageProviderChangeListener)taskSseExchange);
    }

    @Test
    void sseConnectionIsClosedIfTaskStateIsDeleted() throws IOException {
        TaskSseExchange taskSseExchange = new TaskSseExchange(this.httpExchange, this.storageProvider, (JsonMapper)new JacksonJsonMapper());
        taskSseExchange.onChange(TaskTestBuilder.aDeletedTask().build());
        ((PartitionedStorageProvider)Mockito.verify((Object)this.storageProvider)).removeTaskStorageOnChangeListener((StorageProviderChangeListener)taskSseExchange);
    }

    @Test
    void sseConnectionIsClosedIfTaskStateIsFailed() throws IOException {
        TaskSseExchange taskSseExchange = new TaskSseExchange(this.httpExchange, this.storageProvider, (JsonMapper)new JacksonJsonMapper());
        taskSseExchange.onChange(TaskTestBuilder.aFailedTask().build());
        ((PartitionedStorageProvider)Mockito.verify((Object)this.storageProvider)).removeTaskStorageOnChangeListener((StorageProviderChangeListener)taskSseExchange);
    }

    @Test
    void closeRemovesSseExchangeFromStorageProviderListeners() throws IOException {
        TaskSseExchange taskSseExchange = new TaskSseExchange(this.httpExchange, this.storageProvider, (JsonMapper)new JacksonJsonMapper());
        taskSseExchange.close();
        ((PartitionedStorageProvider)Mockito.verify((Object)this.storageProvider)).removeTaskStorageOnChangeListener((StorageProviderChangeListener)taskSseExchange);
    }
}

