/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.dashboard.ui.model.problems;

import cn.boboweike.carrot.dashboard.ui.model.problems.CpuAllocationIrregularityProblem;
import cn.boboweike.carrot.dashboard.ui.model.problems.CpuAllocationIrregularityProblemHandler;
import cn.boboweike.carrot.dashboard.ui.model.problems.Problem;
import cn.boboweike.carrot.dashboard.ui.model.problems.Problems;
import cn.boboweike.carrot.server.dashboard.CpuAllocationIrregularityNotification;
import cn.boboweike.carrot.storage.CarrotMetadata;
import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
public class CpuAllocationIrregularityProblemHandlerTest {
    @Mock
    Problems problems;
    @Mock
    PartitionedStorageProvider storageProvider;
    @Captor
    ArgumentCaptor<Problem> problemArgumentCaptor;
    CpuAllocationIrregularityProblemHandler cpuAllocationIrregularityProblemHandler;

    @BeforeEach
    void setUpNewCarrotVersionProblemHandler() {
        this.cpuAllocationIrregularityProblemHandler = new CpuAllocationIrregularityProblemHandler(this.problems, this.storageProvider);
        this.cpuAllocationIrregularityProblemHandler.onChange(Collections.emptyList());
        Mockito.reset((Object[])new Problems[]{this.problems});
    }

    @Test
    void ifNoChangesOnCpuAllocationIrregularitiesThenNoProblemsCreated() {
        this.cpuAllocationIrregularityProblemHandler.onChange(Collections.emptyList());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.problems});
    }

    @Test
    void ifChangesOnCpuAllocationIrregularitiesDetectedThenProblemCreated() {
        CarrotMetadata carrotMetadata = new CarrotMetadata(CpuAllocationIrregularityNotification.class.getSimpleName(), "BackgroundTaskServer " + UUID.randomUUID(), "23");
        this.cpuAllocationIrregularityProblemHandler.onChange(Arrays.asList(carrotMetadata));
        ((Problems)Mockito.verify((Object)this.problems)).addProblem((Problem)this.problemArgumentCaptor.capture());
        ((ObjectAssert)Assertions.assertThat((Object)((Problem)this.problemArgumentCaptor.getValue())).isInstanceOf(CpuAllocationIrregularityProblem.class)).hasFieldOrPropertyWithValue("cpuAllocationIrregularityMetadataSet", Arrays.asList(carrotMetadata));
    }

    @Test
    void ifCpuAllocationIrregularitiesIsDeletedThenProblemIsRemoved() {
        CarrotMetadata carrotMetadata = new CarrotMetadata(CpuAllocationIrregularityNotification.class.getSimpleName(), "BackgroundTaskServer " + UUID.randomUUID(), "23");
        this.cpuAllocationIrregularityProblemHandler.onChange(Arrays.asList(carrotMetadata));
        Mockito.reset((Object[])new Problems[]{this.problems});
        this.cpuAllocationIrregularityProblemHandler.onChange(Collections.emptyList());
        ((Problems)Mockito.verify((Object)this.problems)).removeProblemsOfType("cpu-allocation-irregularity");
        ((Problems)Mockito.verify((Object)this.problems, (VerificationMode)Mockito.never())).addProblem((Problem)ArgumentMatchers.any());
    }

    @Test
    void ifCpuAllocationIrregularitiesIsDismissedThenProblemIsRemovedAndDeletedFromStorageProvider() {
        CarrotMetadata carrotMetadata = new CarrotMetadata(CpuAllocationIrregularityNotification.class.getSimpleName(), "BackgroundTaskServer " + UUID.randomUUID(), "23");
        this.cpuAllocationIrregularityProblemHandler.onChange(Arrays.asList(carrotMetadata));
        Mockito.reset((Object[])new Problems[]{this.problems});
        this.cpuAllocationIrregularityProblemHandler.dismiss();
        ((Problems)Mockito.verify((Object)this.problems)).removeProblemsOfType("cpu-allocation-irregularity");
        ((PartitionedStorageProvider)Mockito.verify((Object)this.storageProvider)).deleteMetadata(CpuAllocationIrregularityNotification.class.getSimpleName());
    }
}

