/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.fixtures;

import ch.qos.logback.LoggerAssert;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.read.ListAppender;
import cn.boboweike.carrot.fixtures.dashboard.server.http.client.HttpResponseAssert;
import cn.boboweike.carrot.fixtures.server.BackgroundTaskServerAssert;
import cn.boboweike.carrot.fixtures.storage.CarrotMetadataAssert;
import cn.boboweike.carrot.fixtures.storage.PartitionedStorageProviderAssert;
import cn.boboweike.carrot.fixtures.tasks.RecurringTaskAssert;
import cn.boboweike.carrot.fixtures.tasks.TaskAssert;
import cn.boboweike.carrot.fixtures.tasks.TaskDetailsAssert;
import cn.boboweike.carrot.server.BackgroundTaskServer;
import cn.boboweike.carrot.storage.CarrotMetadata;
import cn.boboweike.carrot.storage.ConcurrentTaskModificationException;
import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import cn.boboweike.carrot.tasks.RecurringTask;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.TaskDetails;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import javax.sql.DataSource;
import net.javacrumbs.jsonunit.assertj.JsonAssert;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.ListAssert;
import org.assertj.db.DatabaseAssertions;

public class CarrotAssertions
extends Assertions {
    public static Condition<Throwable> failedTask(Task task) {
        return new Condition(x -> x instanceof ConcurrentTaskModificationException && ((ConcurrentTaskModificationException)x).getConcurrentUpdatedTasks().contains(task), "Should contain task", new Object[0]);
    }

    public static <T extends Task> ListAssert<T> assertThatTasks(List<T> tasks) {
        return (ListAssert)Assertions.assertThat(tasks).usingRecursiveFieldByFieldElementComparator();
    }

    public static TaskAssert assertThat(Task task) {
        return TaskAssert.assertThat(task);
    }

    public static RecurringTaskAssert assertThat(RecurringTask recurringTask) {
        return RecurringTaskAssert.assertThat(recurringTask);
    }

    public static TaskDetailsAssert assertThat(TaskDetails taskDetails) {
        return TaskDetailsAssert.assertThat(taskDetails);
    }

    public static CarrotMetadataAssert assertThat(CarrotMetadata metadata) {
        return CarrotMetadataAssert.assertThat(metadata);
    }

    public static BackgroundTaskServerAssert assertThat(BackgroundTaskServer backgroundTaskServer) {
        return BackgroundTaskServerAssert.assertThat(backgroundTaskServer);
    }

    public static PartitionedStorageProviderAssert assertThat(PartitionedStorageProvider storageProvider) {
        return PartitionedStorageProviderAssert.assertThat(storageProvider);
    }

    public static HttpResponseAssert assertThat(HttpResponse httpResponse) {
        return HttpResponseAssert.assertThat(httpResponse);
    }

    public static JsonAssert.ConfigurableJsonAssert assertThatJson(String json) {
        return JsonAssertions.assertThatJson((Object)json);
    }

    public static LoggerAssert assertThat(ListAppender<ILoggingEvent> listAppender) {
        return LoggerAssert.assertThat(listAppender);
    }

    public static DatabaseAssertions assertThat(DataSource dataSource) {
        return DatabaseAssertions.assertThat(dataSource);
    }

    public static String contentOfResource(String resourceName) {
        try {
            return Files.readString(Paths.get(CarrotAssertions.class.getResource(resourceName).toURI()));
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }
}

