/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.fixtures.dashboard.server.http.client;

import cn.boboweike.carrot.fixtures.CarrotAssertions;
import java.net.http.HttpResponse;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;

public class HttpResponseAssert
extends AbstractAssert<HttpResponseAssert, HttpResponse> {
    private HttpResponseAssert(HttpResponse httpResponse) {
        super((Object)httpResponse, HttpResponseAssert.class);
    }

    public static HttpResponseAssert assertThat(HttpResponse httpResponse) {
        return new HttpResponseAssert(httpResponse);
    }

    public HttpResponseAssert hasStatusCode(int statusCode) {
        Assertions.assertThat((int)((HttpResponse)this.actual).statusCode()).isEqualTo(statusCode);
        return this;
    }

    public HttpResponseAssert hasSameJsonBodyAsResource(String resourceName) {
        this.hasJsonBody(CarrotAssertions.contentOfResource(resourceName));
        return this;
    }

    public HttpResponseAssert hasJsonBody(String bodyAsString) {
        String actualResponseAsString = ((HttpResponse)this.actual).body().toString();
        JsonAssertions.assertThatJson((Object)actualResponseAsString).isEqualTo((Object)bodyAsString);
        return this;
    }

    public HttpResponseAssert hasJsonBody(JsonAssertions.JsonAssertionCallback ... callbacks) {
        String actualResponseAsString = ((HttpResponse)this.actual).body().toString();
        JsonAssertions.assertThatJson((Object)actualResponseAsString, (JsonAssertions.JsonAssertionCallback[])callbacks);
        return this;
    }

    public HttpResponseAssert hasBodyStartingWith(String expected) {
        String actualResponseAsString = ((HttpResponse)this.actual).body().toString();
        Assertions.assertThat((String)actualResponseAsString).startsWith((CharSequence)expected);
        return this;
    }

    public HttpResponseAssert hasBodyContaining(String ... expected) {
        String actualResponseAsString = ((HttpResponse)this.actual).body().toString();
        for (String string : expected) {
            Assertions.assertThat((String)actualResponseAsString).contains(new CharSequence[]{string});
        }
        return this;
    }
}

