/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.fixtures.dashboard.server.http.client;

import cn.boboweike.carrot.utils.exceptions.Exceptions;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;

public class TeenyHttpClient {
    private final String baseUri;
    private final HttpClient httpClient;

    public TeenyHttpClient(String baseUri) {
        this.baseUri = baseUri;
        this.httpClient = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).build();
    }

    public HttpResponse<String> get(String url) {
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(this.baseUri + url)).build();
        return (HttpResponse)this.unchecked(() -> this.httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString()));
    }

    public HttpResponse<String> get(String url, Object ... params) {
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(this.baseUri + String.format(url, params))).build();
        return (HttpResponse)this.unchecked(() -> this.httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString()));
    }

    public HttpResponse<String> delete(String url, Object ... params) {
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(this.baseUri + String.format(url, params))).DELETE().build();
        return (HttpResponse)this.unchecked(() -> this.httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString()));
    }

    private <T> T unchecked(Exceptions.ThrowingSupplier<T> throwingSupplier) {
        try {
            return (T)throwingSupplier.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public HttpResponse<String> post(String url, Object ... params) {
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(this.baseUri + String.format(url, params))).POST(HttpRequest.BodyPublishers.noBody()).build();
        return (HttpResponse)this.unchecked(() -> this.httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString()));
    }
}

